/*
 * Decompiled with CFR 0.152.
 */
package com.belenus.interpartsserver3;

import com.belenus.interpartsserver3.NoServerException;
import com.belenus.interpartsserver3.ServerDispatcherInterface;
import com.belenus.util.Configurator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class InterpartsServlet
extends HttpServlet {
    private String CLASSNAME = "com.belenus.interpartsserver3.ServerDispatcher";
    protected StringWriter m_problemStringWriter = new StringWriter();
    protected PrintWriter m_problemPrintWriter = new PrintWriter(this.m_problemStringWriter);
    private ServerDispatcherInterface m_serverDispatcherInterface;
    private boolean registered;
    private static Hashtable interpartsServletInstanceMap = new Hashtable();
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$com$belenus$interpartsserver3$InterpartsServlet;

    public static InterpartsServlet getInstance(String contextPath) {
        return (InterpartsServlet)((Object)interpartsServletInstanceMap.get(contextPath));
    }

    private void registerInstance(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (!this.registered) {
            interpartsServletInstanceMap.put(httpServletRequest.getContextPath(), this);
            this.registered = true;
        }
    }

    private void handleProblem(Throwable throwable) {
        throwable.printStackTrace(this.m_problemPrintWriter);
        ServletContext servletContext = this.getServletContext();
        File webXmlFile = new File(servletContext.getRealPath("/WEB-INF/web.xml"));
        File directoryBase = webXmlFile.getParentFile().getParentFile();
        File errorFile = new File(directoryBase, "WEB-INF/throwable.log");
        System.err.println("================ " + new Date() + " ================");
        throwable.printStackTrace(System.err);
        try {
            FileWriter fileWriter = new FileWriter(errorFile.toString(), true);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            printWriter.println("================ " + new Date() + " ================");
            throwable.printStackTrace(printWriter);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException ioException) {
            // empty catch block
        }
    }

    private void printClassHierarchy(Class clazz) {
        List<Class<?>> interfaces = Arrays.asList(clazz.getInterfaces());
        System.out.println(clazz.getName() + "   " + interfaces);
        if (clazz != (class$java$lang$Object == null ? (class$java$lang$Object = InterpartsServlet.class$("java.lang.Object")) : class$java$lang$Object)) {
            this.printClassHierarchy(clazz.getSuperclass());
        }
    }

    private void checkCompilation() throws Throwable {
        try {
            StringBuffer testCompilation1 = new StringBuffer("Check");
            StringBuffer testCompilation2 = new StringBuffer("Compilation");
            testCompilation1.append(testCompilation2);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            throw new Throwable("This class was compiled by Java 1.4 or above, but is run on Java 1.3 or below. Please recompile.");
        }
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        try {
            super.init(servletConfig);
            this.checkCompilation();
            Class<?> serverDispatcherClass = Class.forName(this.CLASSNAME);
            Constructor<?> constructor = serverDispatcherClass.getConstructor(class$com$belenus$interpartsserver3$InterpartsServlet == null ? (class$com$belenus$interpartsserver3$InterpartsServlet = InterpartsServlet.class$("com.belenus.interpartsserver3.InterpartsServlet")) : class$com$belenus$interpartsserver3$InterpartsServlet);
            this.m_serverDispatcherInterface = (ServerDispatcherInterface)constructor.newInstance(new Object[]{this});
            this.m_serverDispatcherInterface.init(servletConfig);
        }
        catch (Throwable throwable) {
            this.handleProblem(throwable);
        }
    }

    public void destroy() {
        try {
            super.destroy();
            if (this.m_serverDispatcherInterface != null) {
                this.m_serverDispatcherInterface.destroy();
            }
        }
        catch (Throwable throwable) {
            this.handleProblem(throwable);
        }
    }

    public String getServletName() {
        return "Belenus Server";
    }

    public String getServletInfo() {
        return "Belenus Server";
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            this.registerInstance(httpServletRequest, httpServletResponse);
            if ("get".equals(httpServletRequest.getAttribute("interpartsserver.intern.instance"))) {
                httpServletRequest.setAttribute("interpartsserver.intern.instance", (Object)this);
            } else {
                this.m_serverDispatcherInterface.handle(httpServletRequest, httpServletResponse);
            }
        }
        catch (NoServerException noServerException) {
            throw new ServletException((Throwable)noServerException);
        }
        catch (Throwable throwable) {
            this.handleProblem(throwable);
            throw new ServletException(throwable);
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            this.registerInstance(httpServletRequest, httpServletResponse);
            if ("get".equals(httpServletRequest.getAttribute("interpartsserver.intern.instance"))) {
                httpServletRequest.setAttribute("interpartsserver.intern.instance", (Object)this);
            } else {
                this.m_serverDispatcherInterface.handle(httpServletRequest, httpServletResponse);
            }
        }
        catch (NoServerException noServerException) {
            throw new ServletException((Throwable)noServerException);
        }
        catch (Throwable throwable) {
            this.handleProblem(throwable);
            throw new ServletException(throwable);
        }
    }

    public Properties getConfigProperties(HttpServletRequest httpServletRequest) {
        try {
            return this.m_serverDispatcherInterface.getConfigProperties(httpServletRequest);
        }
        catch (NoServerException noServerException) {
            return null;
        }
        catch (Throwable throwable) {
            this.handleProblem(throwable);
            return null;
        }
    }

    public Configurator getConfigurator(HttpServletRequest httpServletRequest) {
        try {
            return this.m_serverDispatcherInterface.getConfigurator(httpServletRequest);
        }
        catch (NoServerException noServerException) {
            return null;
        }
        catch (Throwable throwable) {
            this.handleProblem(throwable);
            return null;
        }
    }

    public Locale getDataLocale(HttpServletRequest httpServletRequest) {
        return this.m_serverDispatcherInterface.getDataLocale(httpServletRequest);
    }

    public Locale getGuiLocale(HttpServletRequest httpServletRequest) {
        return this.m_serverDispatcherInterface.getGuiLocale(httpServletRequest);
    }

    public ArrayList getServerNames(HttpServletRequest httpServletRequest) {
        return this.m_serverDispatcherInterface.getServerNames(httpServletRequest);
    }

    public String getCurrentServerName(HttpServletRequest httpServletRequest) {
        return this.m_serverDispatcherInterface.getCurrentServerName(httpServletRequest);
    }

    public String getCurrentRange(HttpServletRequest httpServletRequest) {
        return this.m_serverDispatcherInterface.getCurrentRange(httpServletRequest);
    }

    public boolean isActive(String serverName) {
        return this.m_serverDispatcherInterface.isActive(serverName);
    }

    public void checkAvailability(String serverName) throws Throwable {
        this.m_serverDispatcherInterface.checkAvailability(serverName);
    }

    public static InterpartsServlet getInstance(String serverUrl, Servlet servlet, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        Object interpartsServletObject = null;
        httpServletRequest.setAttribute("interpartsserver.intern.instance", (Object)"get");
        RequestDispatcher requestDispatcher = servlet.getServletConfig().getServletContext().getRequestDispatcher(serverUrl);
        try {
            requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            interpartsServletObject = httpServletRequest.getAttribute("interpartsserver.intern.instance");
            String currentRange = ((InterpartsServlet)((Object)interpartsServletObject)).getCurrentRange(httpServletRequest);
            System.out.println("InterpartsServlet.getInstance(): CurrentRange=" + currentRange);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (interpartsServletObject == null || !(interpartsServletObject instanceof InterpartsServlet)) {
            throw new ServletException("Interparts Servlet not found");
        }
        return (InterpartsServlet)((Object)interpartsServletObject);
    }

    public static boolean doLogin(String serverUrl, Servlet otherServlet, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String queryName, String passwordParameter, String randomString, String md5String) throws ServletException {
        InterpartsServlet interpartsServlet = InterpartsServlet.getInstance(serverUrl, otherServlet, httpServletRequest, httpServletResponse);
        return interpartsServlet.m_serverDispatcherInterface.doLogin(httpServletRequest, httpServletResponse, queryName, passwordParameter, randomString, md5String);
    }

    public static void initDatabaseManager(String serverUrl, Servlet otherServlet, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        InterpartsServlet interpartsServlet = InterpartsServlet.getInstance(serverUrl, otherServlet, httpServletRequest, httpServletResponse);
        interpartsServlet.m_serverDispatcherInterface.initDatabaseManager(httpServletRequest, httpServletResponse);
    }

    public static void finishDatabaseManager(String serverUrl, Servlet otherServlet, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        InterpartsServlet interpartsServlet = InterpartsServlet.getInstance(serverUrl, otherServlet, httpServletRequest, httpServletResponse);
        interpartsServlet.m_serverDispatcherInterface.finishDatabaseManager(httpServletRequest, httpServletResponse);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

